/************************************************************************
 *FILE:           amcontrol_clienthandler_LCM.h
 *SW-COMPONENT:   AmControllerPlugin
 *DESCRIPTION:    ClientHandler for LCM
 *AUTHOR:         Parusharam J (RBEI/ECV3) <Parusharam.J@in.bosch.com>
 *COPYRIGHT:      RBEI
 *HISTORY:
 *08.10.2015      Rev 1.0     Parusharam J (RBEI/ECV3)  Initial Revision
 ************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_LCM_H_IF
#define INCLUDE_AMCONTROL_CLIENT_LCM_H_IF

class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;

class amcontrol_clienthandler_LCM : public CThreadSwitchingClient
{
private:
  am::IAmControlReceive& m_ControlReceive;
  CAmControlSenderBase& m_ControlSenderBase;

public:

  // callback functions for new messages invoked from Genivi Audiomanager thread
  virtual void vDispatchMessage (FIMessaging::FIMessage oMsg);
  virtual void vOnServiceAvailable();
  virtual void vOnServiceUnavailable();
  //Default Constructor
  amcontrol_clienthandler_LCM(CAmControlSenderBase&,am::IAmControlReceiverShadow&, am::IAmControlReceive& controlReceive);
  virtual ~amcontrol_clienthandler_LCM();
  void vRegisterForProperties();

   // - - - - - - - - - - - - - - - - - - - -
   //
   //      ITarget implementation

   // disclose list of properties which should be UpReg'ed automatically
   virtual FIMessaging::ITarget::AutoRegisterList GetAutoRegisterList (void);

   // - - - - - - - - - - - - - - - - - - - -

   bool bHandleStatus (const FIMessaging::FIMessage& oMsg);
   bool bHandleError (const FIMessaging::FIMessage& oMsg);

private:
  bool bGetAudioStateLCMStatus(const FIMessaging::FIMessage& oMsg);
  bool bGetAudioStateLCMError(const FIMessaging::FIMessage& oMsg);
};

#endif //INCLUDE_AMCONTROL_CLIENT_LCM_H_IF
